(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     36376,       1008]*)
(*NotebookOutlinePosition[     37218,       1035]*)
(*  CellTagsIndexPosition[     37174,       1031]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ScriptMinSize->7,
  FontSize->10,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PageHeaderLines->{True, True},
  PrintingOptions->{"FirstPageHeader"->False,
  "FacingPages"->True},
  CellBracketOptions->{"Color"->RGBColor[0, 0, 0.466667]},
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Header Graphic (to be pasted in)", "Section"],

Cell[CellGroupData[{

Cell[StyleData["HeaderCell"],
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {0, 0}},
  Evaluatable->False,
  PageBreakBelow->False,
  ImageSize->{350, 24},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  StyleMenuListing->None],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005N000061000`40O003h00OJgoo00Ikog?NJia[
W7>LNmh4Ool00gOoJg]c_@05Ool01GOoJke[NfnLOmh0g7oo001YOol047?oDeU6DTV]CHa1cSIc?YAJ
mgNmOomSW56<@NlfLe[g0Woo00U_oe<HBLi=JdG>=U8nU5lGMmh0fWoo001XOol00f_NH:El0005O000
16R4=Li2eVIB0g`000EXHcHaKke__FAS00El0004H:D^4DjDMmkIOol006Moo`03Nomh07`000Ql0003
>Q1l07`000=l0003CLeO_G`000Ql0003<Q1JmWoo0=Qoo`0000MVNFIjHWYVNV9jIWYRN@02IWX0269i
IWYVNV9jIWYRNFIjHWX2IWX00f9iIWYRNP02IWX2HWX2IWX00f9iHWYVN@02IWX01F9jIWYVNFIjHWX0
0VIj01=RNVIjHWYVNV9jIWUVNVIiHWYVNVIiHWYVNV9jIWYRNVIjIWURNP02IWX01F9iHWYVNVIjHWX0
0VIj00ERNFIjHWYVNFIj009RNP06IWUVNVIjHWYVNV9j0VIj00=RNVIjIWT00V9j0VIj00ARNVIjIWUR
NP9VNP03HWYVNF9j009VNP03HWYNgW@000]l0003O21l07`0009l0003CM9d0G`000Ql0009L00MKeHF
J[]VVfZjJY]V^fZj009Z^`03J]]Z^f[K009Zf`03K]]ZnfkK009^n`03K_a^nfkl009^o004Kaa^o6lL
La`3Ka`05W<mLaac?7<lLaac?G<lLcec?7LmLeac?GLlLeec?G=MMeecGGMMLeegGG=M0WMM0gMm00Eg
GGMnMgegOWMm00=gOP0=NiigOGMnNiigOWNNNiigOGNNNiigWW^NMkh017^N00Ek_W^NNiik_W^O00Ik
_P0>Nkmo_W^oNmik_gnoNmio_g_OOmmkgWnoOmmkg`Aog`03NmmoggoO009og`03OomoggoO065oo`00
00<d43P@>1000SP@00Hd4CP@=10h43PA=102>1001C@@>10h43P@=1000SP@00<d43P@=1000cP@00ld
43P@>14h43@@>10d43P@=14h43@@>10d43P@=1000SP@00Ld43P@=14h43@@>10d4@02>10013@@>10d
43P@0S@@00<h43@@>1000SP@00Td43P@>10d43PA>10d43P@=1000cP@00Ld43P@=10h43@@>10d4002
>1001C@@>10h43P@=1000SP@00@d43P@>10d408h4006=10h43@@>10d4CP?1G`000<l:TQ>O00017`0
00I41W`0O01l05`W?2h5O0000f`2O01l0003O0001B@692dlDT1a?7800T2B00A0Td2bA;=4/`94d`03
A?A8m4Sd00995003CAE9=DdD009=E@03DEIAME5e009AMP05DIIEUUFFEIME]P02EKL015WGEMMIeeGG
15Wh00aN65XHGQQN65hhGQQN>F8hHUUR>69IGUT3HUT0369iHWYVNF9jIWUVNV:IIYYVNVJJI[YZVP9V
^P06J[]Z^V[KJ[]ZffkK0f[K00=Znf[lK_/00Vkk0VlL00=_6flLK_`00W<L00A_?7<lKaac?09c?@09
Leac?G<mLeagGG=MMeegOG=M00=gO@07MiigOGNMMiikWGNNNih00W^n00AkWW^nNkik_`9k_P06Nmmo
gW_OOmikggoOEWoo0002A=<01DBcA=A4ddCCA;<014CC00]4/dCCA==4e4CCA;=4ddBcA=A4ddBc00=4
d`06A;=4e4CCA;=4ddCD0TCC00=4/dCCA=<00TCC00=4/dCDB;<00TCC00E4]4CCA;=4ddCD00A4d`06
A;=4ddCDA==4/dCD0dCC00E4e4CCA==4ddBd00=4d`03A;=4ddSD0094d`03A;=4e4CC00=4d`03A=A4
ddBc0094d`03A=A4ddBc0094d`03A=A4ddBd00A4d`0>A=A4ddBcA=A0e5B_O05d0g@SN05TB3Cg:?QP
9@Al0006:6X`eEB?B;8`nW0S17`000</JRciF8h017`000EL8b3>BAA=5Ddd009==@03DEE=EU5E00=A
MP9EUP0=DIIEUeFgEKII]eGGFMMEeeggFOMIf5hHFOP00ehH00MN>5hIGSQN>68iHUUN>@03HUT01f9i
IUURNFIjHWYVVFIj00AVVP09IY]V^VZJI[]Z^VZkI[]ZfVZj00EZf`07K_]ZnfkLJ_]^nfklK_/00Vkl
00I_6flLKaa^o7<LKc`2La`00flmLaa_?@02Lc`2Lcd02WMLLeecGGMMLeegGG=mMeegOGMM0WMm00Qg
OWNMMgigWWMmNiigWGNN0g^N00=k_W^NMkl017^n00Qo_g_NNkikggoNNmmogWoo0WoO00=ooWoOOol0
EGoo0002A;<0142B?54lDSab0TBc0210Td2BA;=4/cab@58lLCaB?790LSab@994/d2c@58lLT1b@990
LSab@74lDTBBA;=0Tcab@54lLT1bA;=0TSaA0Sab0T2B01LlLT1a?590LSab@590LT2B?790DT2BA;=4
/T1bA;=4Td1b?74lDT1b?78lLD1b0094/`09@78lLSaA@790Tcab@54lLT1b0094/`05@990DSab?590
TP02A;<013ab?34lDSaA0T2B014lDT1b@9=4/d2B?790LSaA@9=0e3SF>?LlecSF?=I8/dAY00El0005
;;50e42d@=@he`04O00017006914dcCi17`000Id01b^A?===DTECC@2CCD01E5ECEEAEE5fDGD00U5f
0UFF00aE]UFgEKII]eGGFKQEeeWhFOMIn5ggFOP4GQP2GST2HSP6HUT01fIjHUUVNF9jIWURVVIi009V
VP05JYYVVfJjJYYV^`02J[X00fZkJ]]Z^P03J]/02fkKJ]]^nf[KK_]Zo6kkJaa^o6kkK_`00VlL00Uc
6flLLaa_?7<lLaa_?G<lLcd00W<l0W<m00=gG7<mLed00W=M01EgGG=MMgecOGMnMgegOWMmNgigOGNN
MiekOW^NMiikWGNnNiik_W^NNkl00W^n00Qo_W_NNkmogg^nNmmogg_O0WoO00AoogoOOomogeEoo`00
02i4/d2BEKMZ^ehHJ[Y8ld1cCEEEUT1bA==VVV9IFMQRFFIiGSUVNUFF@79AMVJJFMMVNU5fGQQRFEWH
IYYAUT1bDGIZ^UWhGSUR>CaBGQQVVUWGIWYEUUVgIWYIf0=RF@0>IYYE]ddeIYYRFEWG@794m5Vg?59=
EFJJGQUN60=RF@0:HSTlLTBcIYYIn68iGQQ=EFZjFOP2HST06D2C@99I]fJjFMQRNEgh?98h46JJMii^
fflLB?AAUVIjIYYAMT1bEGIVVUWGIYYEUT2B00=4/`03A=@leFA800El0006>6/le4RdA==0]3cE17`0
00EH0b2>A;@lmg0T00Al00046:e954dECA@3CCD07deEDEEAEU5eDEIAUUFFDIIEUeFfEIME]eGGFKME
eeWgFMMImeghFOQJ65hGGOQN65hiGQQR>5iIHSUNF68i00=RF@08HWYVFF9iHWYRNFIjIYUVNP=VVP03
I[YVVVJk009Z^P05I[]Z^fJjJ]]Z^`05J]/01FkkJ]a^nfkkK_`00Vkk00=_76kkKa`00flL00Ec76lL
Laac?6lL009c?00=Leec?7=LLcecG7<mLeegGG=MMgegGGMnMed00gMm00IgOWMmMiekOWNNMid3Nih0
0gNNNiik_P02Nkh027^oNkik_goNNkikggnnNml2Oml017_nOmmoogoOEWoo0000?DBc@9=956JJOomE
]dBc?75Mn7oo=110TUFgLceoog<mB?Aoof9IA==0TdCCGQUoogMm@998m7MmOomN64CD@998m5FgOomo
gdSd@79956[LOomVVTBcA?=^o7ooHSU==E5EEIIooddeK_]oodBc@79==Goo>114ddde009oo`07A;=^
o7oOA==4/d2BBCD00Woo00=8m4BcDIH00Woo00U954BB@9=8lehIOomgGDCC>1000Woo00i8e42BHUUo
oe5FOomRFDCC@9=4dehIOomkWT2c0dBc00A4ddBc?=I/A`Al0007>4L<S3b@A;A4/dCC?=H017`000EL
8QR=@;8ln7@R00Al00048<i4m4dEBA@2CCD014eECCE=EE5e0U5f015AME5fEIIAUUFGEKII]UFgEMMI
]eWHFOMIf5WgGQQMn5XH009N6004HQQN>EhHGST2HST00eiIHSURF@02HUT0269jIWURNVIiHWYVVVJI
IWX4IYX01fZjIY]V^VZjJ[]ZffZj009Zf`0EJ[]ZffkKJ_]ZffkkJ_a^g6kkK_a_76kkKaa^o7<KKaac
76llLaa_?6lM009c?00BLcec?7<mLcagGG=MMeegG7=MMeecGGMmMeegOG=nMgegOWNM0WMn00UgWG]n
NiigWG^NMiikWWNnNih01G^n00]k_g_OOmikggnnNmmoogoONmmoogoO05Ioo`0002]4/dCC@98d47^n
>150/caAHSUooeFF?790DT2BOomEUS@@DEERNS`aA;<lDE5EOom4dd1b?59=5GooA==0LTBc@;<d3goo
Ka`h44CC@78lDGooDGHlDP02@780?7ooCEDlDD2C>35AMG<m>15_73`a?79EUWooIWTh<CP@Lceogc@@
>11gOCPA@;=4/c@?OomZVSPA@;<d47ooMcdd44BcA==0Tc0?OomR>3@@FMMoocPa@790/SPAGQQ^fd2b
IYXl<DCC?55AEGooA;=0LTBc?=DX/@8PSP0378m0SGPT00Al0003:4L/STCC0094/`03>=Ml07`000=l
000316/PSR2a00Al0006K00TdDdEBAA==Ddd0Tde00Y=EE5FCEEAEU5eDGIEUU6FEIME]P=E]`9Ie`06
EMMIeeWgGOQIn5Wg0ehH015N>EhHGSQR>EiHHSURFEiIHUURNF9IIWURFVIiHWYVNVIi00EVVP09J[YV
VfZjJ[YZ^fJkJ[YZ^fJk009Zf`0<K_]Zff[KK_]ZffkkJ_]^o6[kK_a_76lK16lL00=c76llLa`00W<l
00Qc?G<lLcecG7<mLeec?G=L0g=M029gOG=MMgegOGMMMgegOWMmMiigOG^NMiegWW^NMiikWW^nMiik
_g^nNkmk_WnoNkikggoNNkiogg_OOmikggoOOomogUMoo`0001m0/dBcA=<lDV[KEII0Tc`aK_aoogoO
?350TT1bOomVVSaA>35k_SaB?34`46ZkOolh4D2c@;90TWooFMLlLP02A;<013PaNgioocPA0TBc038h
4GooIYXlDDBc>11oofIj?554/dSd?790TSaALce0TcaAHUYoogMn@78h<FZkOolh<CaBIWUMn3P@>154
/gooEKI0LTBc?35c?Goo>114ddBcA=<h47ooMgh`3gMMOold44CC0TBc01<lDE6G?35kWSaB?34`46Zk
Oolh4DBc?=EXB6PSG09L8VP106`@[`04O0001f0188m4/dCCA;<leVa600Al0003J08dAg0000Al000;
D2@hlddECAA95DTdDCE==E5ECEEAE@02DGH04U6FDGIEUU6FEIME]UFgFKIEeeVhFMMImeWHFOMN65Wh
GQMJ609N6006GSUN>68iHSUNF68i169I00ERNVIiHWUVNF:J009VNP03IYUVVVJK009VVP05J[YV^fZj
I[YZ^`03J]/016ZjJ]]ZffkK0V[K00I^nfklK_]ZnfklKa/2K_`00flKKaac7002Ka`01W<LKcac76lm
Kcac?09c?@0<LcagG7=MMeecGGMMLeegGGMmLeegOGMn0WMm00agOWMmMiikOG^NNiegWW^NMkikWW^n
Nih4Nkh01g^oOkikgg_OOkmkgW_O00=og`03Oomoggoo05Eoo`0000Q4ddBcA;=0TUFFJ_]0DCPA0Woo
04AIefJJ?54h4GooLa`l<D1bEIIooflLLaaoogoO>114ddBc>15oof9J?554ddBc?55Z^goo<0llLT1b
=0moogMM>354/cPAOom^o30??55gGCaAA;=0LVIjEIHd47^NOom8m6kk=11R>Goo>354TSaBOom_77<L
Niiood2c@994/caAHWYoocPA0dBc00Ph4GMnOol`3WMnOolh4D2c0TBc00e0ddBB?79EUWooKaac77oo
Nmlh442c?=Id9004O0000g0RK09l0003O0000f@1;;54e002A;<00d3DB;9l000:O0001BR_BAE=54TE
CA@00dde0TeE00MAMU5EDGIAMUFFDIIEU`02EKH2EKL04EWGEMMImeWHFOMMn5WgGOQJ65hIGQQN>5hH
HSUN>5hiHST01F9I00QVNV9iIWYRNVIiIWYRVFIj0fJJ00UV^VZkIYYZ^fZjJ]YZ^fZjJ[/00V[K00a^
ff[KJ_]^nf[KK_aZnfklKa]^o6kkLa`4Ka`01g<LKcec76llLaac?7<m009c?005Leec?G=MLeecG002
Led00gMmMeegO@03Mgd037MnMgekWWMmMiigOGNNNiigWW^NMiikWP=k_P0?Nkmk_WnnNkikgWnoNmik
ggnoOomoggooNmmoogoO05Eoo`000dBc00=0/d1bMgh00SPa015oogMM<0moocaB>11oog^o>354/cPa
Okm0LSQAOomZfc`a0094/`0:=11oogMM>354/dCC?59In7ooGOP2HUT0<eWhOomoocPAA;<h<G=MOomV
NW^oNkhh4DBc@99=EF[K<0ioog<m<0ikOSPaEGIood2B@;<l<F[KFMLh<FlLOolh4DBcA=<lLUWGOom0
TT2CA==4/caAIYYoob`>K_aoocP@A;=4d`02A;<0342cA;<h<GoO@78hDGooK]/l<DCC@;A0d`Yl0008
@6/le4BcA;=4dd2c>=M/A`Ul000>D4Lm5DceBAA=54TECCA==DeECCEAEDeEDGIAM@9AMP9EUP05DIMI
]eFfFMME]`02FML015WgFOQImeWh0UhH00UMmehHGQQN>EhHHUUR>5hiGUT00f9I00MRNF9IIUYRNFIj
HWYVN@04IYX01fJjJYYV^VZkI[YV^fZj009Zf`05J[YZff[KJ]]^f`02J]/04FkkJ_]^o6kkJ_]^o6lL
K_]_77;lKaac76llLaa_77<mKc`00W<l0W<m01]c?7=MMcecG7MMLeegGG=MLgegGWMMMgegOWMmMiig
OW^MMiekWWNNNiikWG^NNkigWW^nNil00W^n00ek_g^nNmik_g_NOmmogW_OOmmogWoOOomog`1FOol0
000OA;=0/dCCA;<lDG<LA9=4dgooIWTd46IJIYX`3goOOolh44Bc@79N>E6F>11ooeWG?594ddBc?35g
OWoo>1000TBc02M0LU5EOomIeddeDII8m6klOolh44Bc?55Z^gooA==N67oo?550/dBc@79^o3P@OomR
FC`aDIIRFD2COom9541cA;94/fkl;0ioog^n>1400TBc00E0LTdeOom==D2B0094/`0:?79Mn7oo=11A
MWooA;=0TTBcA=<2A;<024CC@79R>E6F>11ooeWG?782A;<00ccFE8il0007O0001E1Y>=I4]4BcA=<0
0dBc00<dmfa7O0001W`000QHAcTHB?A954SdBAE=54dd0Tde00]=EE5FDEEAMTefEGIAUUFFDIME]UFF
009E]`08FMMEeeWGFMQIeeWhGOQIm`=N6003GSUR65hh009N>@03HUQR>F9I00=RF@07IWYRNVIiHWYV
NFJJIWX00VJJ00YZVVJJIYYVVfJjJ[]Z^VJkJ[YV^`9Zf`0<J[]^nf[KJ]]^nf[kK]a^nf[kK_a_76kk
0VlL00Q_6g<LKaac76lLLca_?7<L0W<m00]c?7MLLcacGG=LLcecGGMMLeegOGMM009gO@03LgegOGMn
009gO@06MgikWWMnNiegWW^N0WNN015k_W^NNkik_g^nOkikgWnoNmmo_W_ONkmogWooNmmoogoO05Mo
o`0001m4/dCCA;=0/d1bGQQEeddeOomE]caB>31ooc@?KaaoocPAA;=0/dBbK_a=5GooB?A0TT2CA;<l
<FZkOolh4@02A;<0:42B@9=ooe6F?350TS`aFMMoocaBA;<lDEhHOold43P@Lce8m42BA;<lDF9JFMMo
oe5f@78h<G<lA==ooeFG?994/caBJ_]4TgooJ[/lDD2B0TBc00@lLWooFOQ0DP94/`08?79=EGooBA@d
47ooJ[/h<@A4/`0??590/T1bK_a=5GooB?A0LTBcA==4/ccFA;=TB7@S009l000:M0=PJ42d?=I4/dCC
A;=0/dBcA=<2A;<02CSGC;1XAg`1O01h0FA6A;4m5`03B?@00dTDCAA95@02CCD02deECCE=EE5FDGEA
MU6EEGIAUUFFEIL00UFf00YI]eGGFKMIeeWgFOQImeWhGOQJ60=N6005GSUR>5hiHUUN>@06HUT01fIi
HWYVNF9jIYUVNVJI009VVP0:IY]Z^VJkJYYV^VZkJ[YZffZjJ[/4J]/016kkJ]]^nf[k0Vkl00A^nfkl
Kaa^n`E_7004Lcac77<lKc`2Lc`2Lcd01W=MMcecGG=MLeacG@9gG@03LgegGGMm009gO@9gOP0:Mgeg
WWMmMiikWW^MMiik_W^NMih3Nkh01W^oNkik_W_NOkikg`9ogP06NmmoggoOOmmoog_OEWoo0005A;<0
34CCIWYR>GooB?A0TT1bHUUIn5ghOollD@94/`0T?59IegooOolh44SdDCDlLCabGQQoocaA@;=0LTde
>35oof9J?554/d2BDEEoodTD@98lTUEfOom9541c@990LTSDA==0TdCC0Woo02Q0TT2C@99EUVIjOomI
md1AA;=0TTBcMgeooeFg?35EUcaA@;<h47ooIYXlDD2cA;=8m41bOomIecP@GQQooc`a@794/d2bA;=Z
fd1B?79Ie`9oo`03=10lLT2B00=4/`03@=@leCSG008leP05>?LleD2dA;=0d`03A;<00dCCA;=0/`02
A;<023cD?=HheccF??LleTCeA=<3B?@014dDBAE==DdD0Tde01E=EE5ECEEAMU5EDGIAUUFFDIME]UFG
EKMIeUFgFMMEeeWhFMMIn5hHFOL00ehH00AN>5hHGSUN>09R>@03GUQRFF9I009RF@06IWYRNV9IHWYV
VFIj16JJ00YV^VJJJYYV^VZkJ[YV^fZkJ]]Z^P=Zf`05K]]Zff[KJ]]^o002K_/00f[lKa]^n`02Ka`0
17;lKaac?6lL0W<L00A_?7<MLcac?@9c?004LcecG7LmLe`2Med01g=mMeegGGMmMeegOGMn009gO@06
MiigOGNNNgekWWNN0W^N00AgWW^nNkikW`=k_P04Okmk_W_ONkh2Nml01GoONmioggooOmh0Egoo0000
1d2cA==4/dCCA;<h<FZj009oo`09?350/dBc?35gGEWgOom8e42B0094/`0M=11oogoo>10lLWooB=@d
44BcOom4/cPAA==ogbP=OomgGC0@A;<lLSPAOomI]cPA@78h<GooDGHh4002>34017oo@;=4TR`>0Woo
00Pl<D2cA;<h4G<LOomVNS@@0TBc02Hh4G<LOom4dc`aJ_]c7C@?<0moog^N=10d3gNNEIHX3GooIWXd
430?NkioocPa?58l<E5fOolh<DBc>11oog^NCEEooe5f@994/dCC0dBc00E0ddBcA;=4/dCC00=4/`0<
A==4/dBcA;=4ddBcA==4/dCCA;=0/dBd0TCC00i8e4SdA?=8m4TDCAA954TeCCEA=DeEDEEAEU5e0U5f
00EEMU6FEIIE]eFf009E]`03FMMEeeWG009Im`9In003GOQJ65hH009N6006GSUN668iGSQRFF8i0V9I
00URNF9IIUURNFIjHWUVNV:IIWX016JJ00MV^VJKJ[YV^VZkJ[YZ^`06J]/00fkkJ]]^n`02J_/01Fkl
K_]^o6lLK_/00VlL00ec76lLLca_76llLca_?7<mLcac?G=MLcac?@03Led00g=LMeecG@03Mgd02gMn
MgegOGNNMgegWW^NMgigWG^NMih00W^N00AgWW^NNkik_`=k_P05Ommk_WoONmio_`02Oml01GooNmmo
ggooOml0EGoo0002A;<0442cA;=4/d1bCCEoogoO>114/dCC?79E]goOOom953ab0TBc00llDFZkNihh
DCaBHUUoofIjK_]oog^NHWUoog^nGQP00Woo00A^o4CCCAEgO@9oo`03HYU95GMM009oo`07J[YZ^goo
Oolh44SdK_`00Woo00Dh4DBcA;=0TTTD009oo`0<J]]4ddBc@990/goo?350/cPAOomk_VIj0Woo00ER
FG=MOom4/fkK009oo`0DJ]]4/c@?KaaooehHFOQoogoO?554/caAJYYcGE5fOomE]T1bA==0/`94/`0:
@==4/dBc@;=4ddBc@;=4/dCC@;<2A;<0143CA;=4/d2c0TBc00e0ddBcA==4/dSCA==4m4SdBAA<m4TD
CAE==002CCD3CED2DGH02E6EDGIEUU6GEIIE]UGGEKMEe`02FML03eWHFOQImeghFOMN65XHGQQN>EhH
HSUN>F9IGSQN>@02HUT01VIIHUURNFIjHWYRN@9VNP03IYUVNVZJ00=VVP0?J[YVVfZjI[YZ^f[KI[YZ
^f[KJ[]ZnfkKJ]]^nf[K009^o007J_]^nfklKa]^o6lLKa/00VlL00Ec76llLaa_?G<L009c?007Lcec
?7LmLeec?7=MMe`00W=M00EgOG=NMgegGGMm009gOP0>MgegOW^MMgigWG^NMiikWG^NMkikWW^nNkmo
_P9k_P07Nkmk_W_ONkiogg_NNml00goO00=oogoOOol0EGoo00002TBcA==4/dBc@;90TehhOomkWSPa
0dBc00Dd47ooOomc7D2B0094/`0V@;=0/TdD@9=4/d2BDGI8ldCD>354ddSdBAAA=E5f@;=0TUWG@;=8
m5FF?558deFGB==EUSaaA;=E]eEfCEE4TT2CA==E]dCCA;=0/P=4/`04@794ddSdEKL2A;<05dCC@798
m4BbA;=0TU5EBAA8m3ab?59=54BcDGI4/eFg@794/eVgA;=0/c`aA;800UhH00Y4/cPaA;=4dd2c@998
m3aAB?A0LP=4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00dBc00=4ddBcA;<014Bc00A4ddCD
B=A8l`98m003BAA95DdD00===@03CEEAEU5E009AMP0=EGIAMU6FEIIE]eFFFKME]UVgEMQIeeWgFML0
0UWh00=J65ghGQP00UhH00AN>EhhHSQR>@9RF@0;GUURFF9IHUUVFV9iIWUVNV9iIWYRVP03IYX026Jj
JYYV^fZjI[]Z^VZkJ[X2J]/02FZkJ]]Zff[KK_]ZffkkJ_]^n`02K_`01VlLK_a_6fklKaac709_700;
Laac?7<LKcac?G<lLcec?7<mLeagG@02Led2Med017=MMgegGG=n0gMm00agOW]mMgigWGNNNiekWWNN
NkikWWNnNih2Nkh03G^oOkik_W^nNmmogW^oOmmogWoONmmooWoO05Moo`000TBc00U4ddBc@79cGG<L
J[]In41bA=<00TBc00M0LUFFK_aV^W^NB?A0/`02A;<02T2CA;=4/dBc@790TdBbA;=0TdBC0T2B00i0
TdBB@9=0TTBCA;=0TTBc@9=0TT2c@994Td2C0T2B00M0LT2cA;=4/d2BA990/`03A;<01DCCA;=0TT2C
@98014Bc00M0/dBcA;=4/d2B@9=0TP02A;<0242BA9=0TT2c@794/T2C@983A;<0142c@790LT2c1DBc
00=4TdBc@;<00dBc00E4ddBcA;=4/dCC00=4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00TBc
00I4ddBcA?=4ddSdB=@2BA@02TdDBAE==4deCEE==E5ECEEAME5F0U6F00AEUUFGEIIE]P9E]`09EMMI
eeWGFMMIn5ggFOQMn5XH009N600BGSUN65hHGSURFEhiHSURFF8iHWURFVIiHUURNV9iIYYVNVIi16JJ
00UVVfZJI[]Z^VJjJ]YZ^f[JJ[/00f[K00Y^ff[KJ]]ZnfkkK_aZnfkkK_a^n`9_700EL_a_76lLLaa_
?7<MKcac7G<lLcec?7=MLcacGG<mLeegGG=LLeegOG=M00AgO@08MiigOGMnMiekWWMnNiigWP9kWP05
MiikWW^nNkik_`03Nkh027oONmik_goONmiogg_OOol2Oml00gooOmmoo`1DOol000E4/`04?54lDSaA
@783A;<01TCCA;=0LSaA?58lD@A4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00dBc00E4ddBc
A;=4/dCC00=4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00dBc00E4ddBcA;=4/dCC00=4/`05
A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00dBc00E4ddBcA;=4/dCC00=4/`05A==4/dBcA;=4d`03
A;<01DCCA;=4/dBcA=<00dBc00E4ddBcA;=4/dCC00=4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dSD
A?<014Sd00===DdDBCD00Tde00M=EE5EDEE=MU5eDGIEMP02DIH035FgEIME]UVgFMMEeeWGFMQImeWh
GOQIm`AN6006GSUN>5hhHSURF5iI169I00MRNVIjHWUVNV9iIYYVNP04IYX01VJjJY]Z^VJkJ[YV^`9Z
^`0@J]YZff[KK]]ZffkkJ]]^nf[lK]]^o6[lK_]_76klKa/2Ka`01W<LKaac76llLca_?09c?007Lcec
?7=MLcacGGLlLgd00WMM00=cGGMmMed00gMm0WMn00MgWGMnMgekWGNNNiigW@02Nih00gNnNiik_`03
Nkh01gnoNkikggoNNmmogg_N009og`9oo`03Ommoogoo05Aoo`000814/dCDA;=4e4BcA=A4/dCDA;=4
e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4
e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4
e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4
e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dSD0TCC
00A8e4SdB?E9509=5008BAE==E4eCEEAEDeEDGIEMP9AMP08DIIEUUFGEKII]UFgFMMEe`9Ie`05FOMM
meWhGOQJ6003GQP01V8iGSQN>F8iHUUN>@=RF@06IUURNFIJHWUVNV:I0VIj00UVVFJJIYYZVVJjIYYV
^VJkJ[X00VZk00=ZfV[KJ[/00f[K01A^nf[KK_aZffkkK_a[6fkkK_a_6flLLaa_77<LKaac?6llLaa_
77<l0W<m00Ac?7<mMcac?@EcG@0@MgegGGMmMeigOGMnMgegWGMnMiikWWNNNiikWG^NMkh2Nih3Nkh0
2G_OOkik_W_NNkmogW^oOmikg`02Oml00gooOmmog`1FOol0008/3P04<0h/3R`><0h2;0h0130>;0h/
3S0>0R`>00@`3R`>;0h`3P8/3P04<0h/3R`><0h2;0h0130>;0h/3S0>0R`>00@`3R`>;0h`3P8/3P04
<0h/3R`><0h2;0h0130>;0h/3S0>0R`>00@`3R`>;0h`3P8/3P04<0h/3R`><0h2;0h0130>;0h/3S0>
0R`>00@`3R`>;0h`3P8/3P04<0h/3R`><0h2;0h0130>;0h/3S0>0R`>00@`3R`>;0h`3P8/3P04<0h/
3R`><0h2;0h0130>;0h/3S0>0R`>00@`3R`>;0h`3P8/3P04<0h/3R`><0h2;0h0130>;0h/3S0>0R`>
00@`3R`>;0h`3P8/3P05<0l`3S0?<0ld3`03=102>103>342?5400cab@790TP02@9800dBc@;=4d`02
A=<2B?@3BA@04TddBCE==DeDCEEAEDeeDEIAME6FDGIEUU6FEKIE]eFfEKMIeP9Ee`07FMMImeWgFOQI
meghFQP015hH0ehh00AR>EiHHUUNF@=RF@9RN@05IWURNVJIIWYVV@03IYX3I[X016ZkI[YZ^f[J0V[K
00YZfV[KJ_]^nf[kK_]^o6lKK_a_6`=_700KLca_?7<LKcac?G<lLeac?7=MLeacGGMmLeegOG=mMgec
OGMnMiegOGNNNiigWG^nMiik_WNn009k_P07Nmik_goNNmikggoOOoh0Dgoo0000

\>"], "Graphics",
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {Inherited, 0}},
  Evaluatable->False,
  ImageSize->{350, 24},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  ShowCellBracket->False,
  CellMargins->{{60, 0}, {0, 5}},
  PageBreakBelow->False,
  LineSpacing->{0, 37},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontSize->36,
  FontTracking->"Plain",
  FontColor->GrayLevel[0]],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{9, 0}, {0, 0}},
  FontSize->24,
  FontTracking->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  ShowCellBracket->False,
  CellMargins->{{60, 0}, {0, 5}},
  PageBreakBelow->False,
  LineSpacing->{1, 0},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{9, 0}, {0, 0}},
  ParagraphIndent->-85,
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  ShowCellBracket->False,
  CellMargins->{{60, 4}, {30, 10}},
  PageBreakBelow->False,
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->12,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{9, 10}, {50, 10}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{6, 0}, {0, 1}},
  CellDingbat->None,
  CellMargins->{{44, 0}, {10, 35}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->{{8, 4}, {0, 4}},
  LineSpacing->{0, 22},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{9, 0}, {2, 50}},
  CellFrameMargins->{{5, 4}, {0, 4}},
  FontSize->14,
  FontTracking->"Plain",
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellMargins->{{60, 0}, {8, 10}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{9, 0}, {6, 40}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{60, Inherited}, {8, 12}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->13,
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{22, 0}, {4, 20}},
  FontSize->11]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{60, 20}, {10, 5}},
  LineSpacing->{1, 0},
  ParagraphSpacing->{0, 12},
  FontFamily->"Times"],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{9, 0}, {4, 4}},
  ParagraphSpacing->{0, 6}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Commentary"],
  CellMargins->{{60, 20}, {2, 8}},
  PageBreakBelow->False,
  TextJustification->1,
  LineSpacing->{1, 2},
  FontFamily->"Helvetica",
  FontSize->10,
  FontColor->RGBColor[0, 0, 0.4]],

Cell[StyleData["Commentary", "Printout"],
  CellMargins->{{9, 0}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{60, 20}, {0, 0}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  CellFrameColor->RGBColor[0.6, 0.2, 0],
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold",
  Background->RGBColor[1, 0.700008, 0.4]],

Cell[StyleData["Input", "Printout"],
  CellFrame->False,
  CellMargins->{{37, 0}, {6, 6}},
  Background->GrayLevel[0.8]]
}, Closed]],

Cell[StyleData["InlineInput"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{60, 20}, {15, 0}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  CellFrameColor->RGBColor[0, 0.500008, 0.6],
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Output",
  Background->RGBColor[1, 0.900008, 0.900008]],

Cell[StyleData["Output", "Printout"],
  CellFrame->False,
  CellMargins->{{37, 0}, {6, 2}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{60, 20}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellFrameColor->RGBColor[0, 0.6, 0.6],
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageSize->{250, 250},
  Background->RGBColor[1, 0.900008, 0.900008]],

Cell[StyleData["Graphics", "Printout"],
  CellFrame->False,
  CellMargins->{{37, 0}, {6, 2}},
  ImageSize->{250, 250},
  ImageMargins->{{28, Inherited}, {Inherited, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{72, 20}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  StyleMenuListing->None,
  FontColor->RGBColor[1, 0, 0]],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{44, Inherited}, {Inherited, Inherited}},
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{72, 20}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  StyleMenuListing->None],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{44, Inherited}, {Inherited, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontTracking->"Extended",
  FontColor->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["DisplayText"],
  CellFrame->0.5,
  CellMargins->{{60, 20}, {15, 5}},
  LineSpacing->{0, 12},
  ParagraphSpacing->{0, 6},
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold",
  FontSlant->"Plain",
  Background->RGBColor[1, 1, 0.8]],

Cell[StyleData["DisplayText", "Printout"],
  CellMargins->{{9, 0}, {4, 4}},
  ParagraphSpacing->{0, 6},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{60, Inherited}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  ShowCellLabel->False,
  CellFrameColor->RGBColor[0, 0.6, 0.6],
  CounterIncrements->"Graphics",
  ImageSize->{250, 250},
  Background->RGBColor[1, 0.900008, 0.900008]],

Cell[StyleData["PictureGroup", "Printout"],
  CellFrame->False,
  CellMargins->{{37, Inherited}, {6, 2}},
  ImageSize->{250, 250},
  ImageMargins->{{28, Inherited}, {Inherited, 0}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontSlant->"Italic"],

Cell[StyleData["Footer"],
  CellMargins->{{0, 0}, {0, 4}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->6],

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Presentation"]],

Cell[StyleData["Hyperlink", "Condensed"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Presentation"]],

Cell[StyleData["MainBookLink", "Condensed"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Presentation"]],

Cell[StyleData["AddOnsLink", "Condensed"]],

Cell[StyleData["AddOnLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Presentation"]],

Cell[StyleData["RefGuideLink", "Condensed"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Presentation"]],

Cell[StyleData["GettingStartedLink", "Condensed"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Presentation"]],

Cell[StyleData["OtherInformationLink", "Condensed"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Placeholder Styles", "Section"],

Cell["\<\
The cells below define styles useful for making placeholder objects \
in palette templates.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Placeholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  Placeholder->True,
  StyleMenuListing->None],

Cell[StyleData["Placeholder", "Presentation"]],

Cell[StyleData["Placeholder", "Condensed"]],

Cell[StyleData["Placeholder", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SelectionPlaceholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  Placeholder->Primary,
  StyleMenuListing->None,
  DrawHighlighted->True],

Cell[StyleData["SelectionPlaceholder", "Presentation"]],

Cell[StyleData["SelectionPlaceholder", "Condensed"]],

Cell[StyleData["SelectionPlaceholder", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FormatType Styles", "Section"],

Cell["\<\
The cells below define styles that are mixed in with the styles of \
most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options.\
\>", "Text"],

Cell[StyleData["CellExpression"],
  PageWidth->Infinity,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  ShowCellLabel->False,
  ShowSpecialCharacters->False,
  AllowInlineCells->False,
  AutoItalicWords->{},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->12,
  Background->GrayLevel[1]],

Cell[StyleData["InputForm"],
  AllowInlineCells->False,
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["OutputForm"],
  PageWidth->Infinity,
  TextAlignment->Left,
  LineSpacing->{1, -5},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["StandardForm"],
  LineSpacing->{1.25, 0},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["TraditionalForm"],
  LineSpacing->{1.25, 0},
  SingleLetterItalics->True,
  TraditionalFunctionNotation->True,
  DelimiterMatching->None,
  StyleMenuListing->None],

Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],

Cell[StyleData["InlineCell"],
  TextAlignment->Left,
  ScriptLevel->1,
  StyleMenuListing->None],

Cell[StyleData["InlineCellEditing"],
  StyleMenuListing->None,
  Background->RGBColor[1, 0.749996, 0.8]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{481, 281},
WindowMargins->{{143, Automatic}, {Automatic, 11}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 62, "Subtitle"],
Cell[1771, 53, 193, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 61, 42, 0, 50, "Section"],
Cell[2034, 63, 77, 2, 36, 31, 0, "StyleData", "All", "Working"],
Cell[2114, 67, 140, 4, 34, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2291, 76, 35, 0, 30, "Section"],
Cell[2329, 78, 101, 3, 30, "Text"],
Cell[2433, 83, 560, 14, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3030, 102, 51, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[3106, 106, 252, 8, 28, 29, 0, "StyleData", "HeaderCell", "All",
  StyleMenuListing->None],
Cell[3361, 116, 15119, 192, 28, 14939, 186, "GraphicsData", 
"Bitmap", "Graphics"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18529, 314, 38, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[18592, 318, 273, 8, 57, 24, 0, "StyleData", "Title", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[18868, 328, 110, 3, 40, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[19015, 336, 300, 9, 43, 27, 0, "StyleData", "Subtitle", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[19318, 347, 112, 3, 32, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[19467, 355, 255, 7, 71, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[19725, 364, 94, 2, 91, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[19856, 371, 461, 13, 63, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[20320, 386, 178, 5, 87, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[20535, 396, 281, 8, 52, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[20819, 406, 91, 2, 75, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[20947, 413, 307, 9, 49, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[21257, 424, 95, 2, 51, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21401, 432, 39, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[21465, 436, 134, 4, 43, 23, 0, "StyleData", "Text", "All"],
Cell[21602, 442, 96, 2, 36, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[21735, 449, 213, 7, 33, 29, 0, "StyleData", "Commentary", "All"],
Cell[21951, 458, 112, 3, 32, 41, 0, "StyleData", "Commentary", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[22112, 467, 42, 0, 30, "Section"],
Cell[22157, 469, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[22430, 478, 581, 17, 45, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[23014, 497, 120, 3, 57, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],
Cell[23149, 503, 375, 12, 37, 30, 0, "StyleData", "InlineInput", "All",
  CounterIncrements->"Input"],

Cell[CellGroupData[{
Cell[23549, 519, 579, 16, 59, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[24131, 537, 126, 3, 52, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[24294, 545, 484, 14, 48, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics"],
Cell[24781, 561, 169, 4, 52, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[24987, 570, 439, 12, 36, 26, 0, "StyleData", "Message", "All",
  StyleMenuListing->None],
Cell[25429, 584, 123, 2, 36, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[25589, 591, 438, 12, 36, 24, 0, "StyleData", "Print", "All",
  StyleMenuListing->None],
Cell[26030, 605, 94, 1, 36, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26161, 611, 222, 7, 34, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[26386, 620, 130, 4, 32, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[26565, 630, 32, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[26622, 634, 258, 9, 66, 30, 0, "StyleData", "DisplayText", "All"],
Cell[26883, 645, 154, 4, 52, 42, 0, "StyleData", "DisplayText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[27074, 654, 374, 10, 56, 31, 0, "StyleData", "PictureGroup", "All",
  CounterIncrements->"Graphics"],
Cell[27451, 666, 181, 4, 52, 43, 0, "StyleData", "PictureGroup", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[27681, 676, 49, 0, 30, "Section"],
Cell[27733, 678, 149, 5, 32, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[27885, 685, 126, 4, 26, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[28014, 691, 152, 5, 33, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[28203, 701, 33, 0, 30, "Section"],
Cell[28239, 703, 121, 3, 46, "Text"],
Cell[28363, 708, 226, 5, 36, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[28592, 715, 295, 7, 36, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[28890, 724, 400, 9, 36, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[29293, 735, 387, 9, 36, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[29683, 746, 401, 9, 36, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[30121, 760, 35, 0, 30, "Section"],
Cell[30159, 762, 184, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[30368, 770, 302, 8, 36, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[30673, 780, 44, 0, 70, 44, 0, "StyleData", "Hyperlink", "Presentation"],
Cell[30720, 782, 41, 0, 70, 41, 0, "StyleData", "Hyperlink", "Condensed"],
Cell[30764, 784, 107, 2, 70, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[30886, 789, 104, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[31015, 796, 316, 8, 36, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[31334, 806, 47, 0, 70, 47, 0, "StyleData", "MainBookLink", 
"Presentation"],
Cell[31384, 808, 44, 0, 70, 44, 0, "StyleData", "MainBookLink", "Condensed"],
Cell[31431, 810, 110, 2, 70, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[31578, 817, 337, 9, 36, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[31918, 828, 45, 0, 36, 45, 0, "StyleData", "AddOnsLink", "Presentation"],

Cell[31966, 830, 42, 0, 36, 42, 0, "StyleData", "AddOnsLink", "Condensed"],
Cell[32011, 832, 107, 2, 36, 40, 0, "StyleData", "AddOnLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[32155, 839, 345, 9, 36, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[32503, 850, 47, 0, 70, 47, 0, "StyleData", "RefGuideLink", 
"Presentation"],
Cell[32553, 852, 44, 0, 70, 44, 0, "StyleData", "RefGuideLink", "Condensed"],
Cell[32600, 854, 110, 2, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[32747, 861, 328, 8, 36, 37, 0, "StyleData", "GettingStartedLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[33078, 871, 53, 0, 70, 53, 0, "StyleData", "GettingStartedLink", 
"Presentation"],
Cell[33134, 873, 50, 0, 70, 50, 0, "StyleData", "GettingStartedLink", 
"Condensed"],
Cell[33187, 875, 116, 2, 70, 49, 0, "StyleData", "GettingStartedLink", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[33340, 882, 332, 8, 36, 39, 0, "StyleData", "OtherInformationLink", 
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[33675, 892, 55, 0, 70, 55, 0, "StyleData", "OtherInformationLink", 
"Presentation"],
Cell[33733, 894, 52, 0, 70, 52, 0, "StyleData", "OtherInformationLink", 
"Condensed"],
Cell[33788, 896, 118, 2, 70, 51, 0, "StyleData", "OtherInformationLink", 
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[33955, 904, 37, 0, 30, "Section"],
Cell[33995, 906, 115, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[34135, 913, 145, 5, 70, 30, 0, "StyleData", "Placeholder", "All",
  StyleMenuListing->None],
Cell[34283, 920, 46, 0, 70, 46, 0, "StyleData", "Placeholder", 
"Presentation"],
Cell[34332, 922, 43, 0, 70, 43, 0, "StyleData", "Placeholder", "Condensed"],
Cell[34378, 924, 42, 0, 70, 42, 0, "StyleData", "Placeholder", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[34457, 929, 182, 6, 70, 39, 0, "StyleData", "SelectionPlaceholder", 
"All",
  StyleMenuListing->None],
Cell[34642, 937, 55, 0, 70, 55, 0, "StyleData", "SelectionPlaceholder", 
"Presentation"],
Cell[34700, 939, 52, 0, 70, 52, 0, "StyleData", "SelectionPlaceholder", 
"Condensed"],
Cell[34755, 941, 51, 0, 70, 51, 0, "StyleData", "SelectionPlaceholder", 
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[34855, 947, 36, 0, 30, "Section"],
Cell[34894, 949, 258, 5, 62, "Text"],
Cell[35155, 956, 314, 10, 36, 33, 0, "StyleData", "CellExpression", "All",
  StyleMenuListing->None],
Cell[35472, 968, 106, 3, 36, 28, 0, "StyleData", "InputForm", "All",
  StyleMenuListing->None],
Cell[35581, 973, 150, 5, 37, 29, 0, "StyleData", "OutputForm", "All",
  StyleMenuListing->None],
Cell[35734, 980, 108, 3, 36, 31, 0, "StyleData", "StandardForm", "All",
  StyleMenuListing->None],
Cell[35845, 985, 179, 5, 36, 34, 0, "StyleData", "TraditionalForm", "All",
  StyleMenuListing->None],
Cell[36027, 992, 115, 3, 30, "Text"],
Cell[36145, 997, 96, 3, 36, 29, 0, "StyleData", "InlineCell", "All",
  StyleMenuListing->None],
Cell[36244, 1002, 104, 2, 52, 36, 0, "StyleData", "InlineCellEditing", "All",
  StyleMenuListing->None]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

